{{-- html5 week input --}}
@php
	$layout ??= 'default'; // default, horizontal
	$isHorizontal = $layout === 'horizontal';
	$colLabel ??= 'col-md-3';
    $colField ??= 'col-md-9';
	
	$viewName = 'week';
	$type = 'week';
	$label ??= null;
	$id ??= null;
	$name ??= null;
	$value ??= null;
	$default ??= null;
	$required ??= false;
	$hint ??= null;
	
	$min ??= null;
	$max ??= null;
	$step ??= null;
	
	$dotSepName = arrayFieldToDotNotation($name);
	$id = !empty($id) ? $id : str_replace('.', '-', $dotSepName);
	
	$value = $value ?? ($default ?? null);
	$value = old($dotSepName, $value);
	
	$attrStr = is_numeric($min) ? ' min="' . $min . '"' : '';
	$attrStr .= is_numeric($max) ? ' max="' . $max . '"' : '';
	$attrStr .= is_numeric($step) ? ' step="' . $step . '"' : '';
@endphp
<div @include('helpers.forms.attributes.field-wrapper')>
	@include('helpers.forms.partials.label')
	
	@if ($isHorizontal)
		<div class="{{ $colField }}">
			@endif
			
			<input
					type="week"
					name="{{ $name }}"
					value="{{ $value }}"{!! $attrStr !!}
					@include('helpers.forms.attributes.field')
			>
			
			@include('helpers.forms.partials.hint')
			@include('helpers.forms.partials.validation')
			
			@if ($isHorizontal)
		</div>
	@endif
</div>
@include('helpers.forms.partials.newline')
