<?php
/*
 * LaraClassifier - Classified Ads Web Application
 * Copyright (c) BeDigit. All Rights Reserved
 *
 * Website: https://laraclassifier.com
 * Author: Mayeul Akpovi (BeDigit - https://bedigit.com)
 *
 * LICENSE
 * -------
 * This software is provided under a license agreement and may only be used or copied
 * in accordance with its terms, including the inclusion of the above copyright notice.
 * As this software is sold exclusively on CodeCanyon,
 * please review the full license details here: https://codecanyon.net/licenses/standard
 */

namespace App\Http\Controllers\Web\Front\Search;

use App\Http\Controllers\Web\Front\FrontController;
use App\Http\Controllers\Web\Front\Search\Traits\MetaTagTrait;
use App\Http\Controllers\Web\Front\Search\Traits\TitleTrait;
use App\Services\PostService;
use Illuminate\Http\Request;

class BaseController extends FrontController
{
	use MetaTagTrait, TitleTrait;
	
	protected PostService $postService;
	
	/**
	 * @param \App\Services\PostService $postService
	 * @param \Illuminate\Http\Request $request
	 */
	public function __construct(PostService $postService, Request $request)
	{
		parent::__construct();
		
		$this->postService = $postService;
		$this->request = $request;
	}
	
	/**
	 * @param array|null $sidebar
	 * @return void
	 */
	protected function bindSidebarVariables(?array $sidebar = []): void
	{
		if (!empty($sidebar)) {
			foreach ($sidebar as $key => $value) {
				view()->share($key, $value);
			}
		}
	}
	
	/**
	 * Set the Open Graph info
	 *
	 * @param $og
	 * @param $title
	 * @param $description
	 * @param array|null $apiExtra
	 * @return void
	 */
	protected function setOgInfo($og, $title, $description, ?array $apiExtra = null): void
	{
		$og->title($title)->description($description)->type('website');
		
		// If listings found, then remove the fallback image
		$doesListingsFound = (is_array($apiExtra) && (int)data_get($apiExtra, 'count.0') > 0);
		if ($doesListingsFound) {
			if ($og->has('image')) {
				$og->forget('image')->forget('image:width')->forget('image:height');
			}
		}
		
		view()->share('og', $og);
	}
}
